% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.define.pop.r
\name{gl.define.pop}
\alias{gl.define.pop}
\title{Defines a new population in a genlight object for specified 
individuals}
\usage{
gl.define.pop(x, ind.list, new, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing SNP genotypes [required].}

\item{ind.list}{A list of individuals to be assigned to the new population
[required].}

\item{new}{Name of the new population [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object with the redefined population structure.
}
\description{
The script reassigns existing individuals to a new population and removes
their existing population assignment.
The script returns a genlight object with the new population assignment.
}
\examples{
popNames(testset.gl)
gl <- gl.define.pop(testset.gl, ind.list=c('AA019073','AA004859'), 
new='newguys')
popNames(gl)
indNames(gl)[pop(gl)=='newguys']

}
\seealso{
Other data manipulation: 
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
