% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.pcoa.scree.r
\name{gl.pcoa.scree}
\alias{gl.pcoa.scree}
\title{Produce a plot of eigenvalues, standardized as percentages, derived from a PCoA}
\usage{
gl.pcoa.scree(x, top = TRUE)
}
\arguments{
\item{x}{-- name of the pcoa file generated by gl.pcoa() [required]}

\item{top}{-- a flag to indicate whether or not plot only those eigenvalues greater in value than the average for the
unordinated original variables (top=TRUE) or to plot all eigenvalues (top=FALSE). If top=FALSE, then a
reference line showing the average eigenvalue for the unordinated variables is shown. [default TRUE]}
}
\value{
The scree plot
}
\description{
This script takes output from gl.pcoa() and produces a plot of eigenvalues, expressed as a percentage of the sum of the
eigenvalues. An option is provided to only plot those eigenvalues with greater explanatory power than the average for
the original variables.
}
\details{
A Scree Plot is a plot of the relative value of eigenvalues, usually expressed as a percentage, that informs a decision
on how many dimensions carry with them substantial information worthy of examination. In an ordination, such as PCoA,
the axes are ordered on the proportion of variation explained, so the first axis explains the most (has the largest eigenvalue),
the second explains the next greatest amount, and so on.
}
\examples{
pcoa <- gl.pcoa(testset.gl)
gl.pcoa.scree(pcoa)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
