% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.amova.r
\name{gl.amova}
\alias{gl.amova}
\title{Performs and AMOVA using genlight data.}
\usage{
gl.amova(x, nperm = 100)
}
\arguments{
\item{x}{-- name of the genlight containing the SNP genotypes, with population information [required]}

\item{nperm}{-- number of permuations to perform for hypothesis testing [default 100]. Please note should be set to 1000 for analysis.]}
}
\value{
An object of class "amova" which is a list with a table of sums of square deviations (SSD), mean square deviations (MSD), and the number of degrees of freedom, and a vector of variance components.
}
\description{
This script performs an AMOVA based on the genetic distance matrix from stamppNeisD() [package StAMPP] using the amova() function from the package PEGAS for exploring within and between population variation. For detailed information use their help pages: ?pegas::amova, ?StAMPP::stamppAmova
}
\author{
Bernd Gruber (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
