% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/node.R
\docType{class}
\name{Node}
\alias{Node}
\title{Create Trees With \code{Node}s}
\format{An \code{\link{R6Class}} generator object}
\usage{
Node
}
\description{
\code{Node} is at the very heart of the \code{data.tree} package. All trees are constructed
by tying toghether \code{Node} objects.
}
\section{Fields}{

\describe{
\item{\code{children}}{A list of children \code{Node}s}

\item{\code{parent}}{The node's parent \code{Node}}
}}
\section{Methods}{


\describe{
  \item{\code{Node$new(name)}}{Creates a new \code{Node} called \code{name}. Often used to construct the root.}
  \item{\code{AddChild(name)}}{Creates a new \code{Node} called \code{name} and adds it to this \code{Node}.}
  \item{\code{\link{Find}(...)}}{Find a node with path \code{...}, where the \code{...} arguments are the \code{name}s of the \code{Node}s }
  \item{\code{\link{Get}(attribute, ..., traversal = "pre-order", filterFun = function(x) TRUE, assign = NULL, format = NULL)}}{Traverses the tree and collects values along the way.}
  \item{\code{\link{Set}(..., traversal = "pre-order", returnValues = FALSE)}}{Traverses the tree and assigns attributes along the way.}
  \item{\code{\link{Aggregate}(attribute, fun, ...)}}{Traverses the tree and calls \code{fun(children$Aggregate(...))} on each node. }
  \item{\code{\link{Sort}(attribute, ..., decreasing = FALSE, recursive = TRUE)}}{Sorts the children of a node according to \code{attribute}}
  \item{\code{\link{ToDataFrame}(row.names = NULL, optional = FALSE, ...)}}{Converts the tree below this \code{Node} to a \code{data.frame}}
}
}

\section{Properties}{


\describe{
 \item{\code{children}}{Returns a list containing all the children of this \code{Node}}
 \item{\code{parent}}{Returns the parent \code{Node} of this \code{Node}}
 \item{\code{name}}{Gets or sets the name of a \code{Node}. For example \code{Node$name <- "Acme"}}
 \item{\code{isLeaf}}{Returns \code{TRUE} if the \code{Node} is a leaf, \code{FALSE} otherwise}
 \item{\code{isRoot}}{Returns \code{TRUE} if the \code{Node} is the root, \code{FALSE} otherwise}
 \item{\code{count}}{Returns the number of children of a \code{Node}}
 \item{\code{totalCount}}{Returns the total number of \code{Node}s in the tree}
 \item{\code{path}}{Returns a vector of mode \code{character} containing the names of the \code{Node}s in the path from the root to this \code{Node}}
 \item{\code{pathString}}{Returns a string representing the path to this \code{Node}, separated by backslash}
 \item{\code{levelName}}{Returns the name of the \code{Node}, preceded by level times '*'. Useful for printing.}
 \item{\code{leaves}}{Returns a list containing all the leaf \code{Node}s }
 \item{\code{level}}{Returns an integer representing the level of a \code{Node}. For example, the root has level 0.}
 \item{\code{root}}{Returns the root \code{Node} of a \code{Node}'s tree}

}
}
\examples{
library(data.tree)
acme <- Node$new("Acme Inc.")
accounting <- acme$AddChild("Accounting")
print(acme)
}
\seealso{
For more details see the \code{data.tree} vignette: \code{vignette("data.tree")}
}
\keyword{datasets}

