% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quartiles.R
\name{quartiles}
\alias{quartiles}
\title{summaryFunction for quartiles}
\usage{
quartiles(v, maxDecimals = 2)
}
\arguments{
\item{v}{A variable (vector) of type numeric or integer.}

\item{maxDecimals}{A positive integer or \code{Inf}. Number of decimals used when
printing numerical values in the data summary and in problematic values from the
data checks. If \code{Inf}, no rounding is performed.}
}
\value{
An object of class \code{summaryResult} with the following entries: \code{$feature} 
("1st and 3rd quartiles"), \code{$result} (the 1st and 3rd quartiles of \code{v}) and
\code{$value} (the quartiles in their original format).
}
\description{
A \code{\link{summaryFunction}}, intended to be called from \code{\link{summarize}}, 
which calculates the 1st and 3rd quartiles of a variable. NA, NaN and Inf values are removed 
prior to  the computations.
}
\details{
The quartiles are computed using the \code{\link[stats]{quantile}} function from \code{stats}, 
using type 7 quantiles for integer and numeric variables and type 1 quantiles for Date variables.
}
\examples{
quartiles(c(1:100))

quartiles(rnorm(1000), maxDecimals = 4)

}
\seealso{
\code{\link{summaryFunction}}, \code{\link{summarize}}, \code{\link{summaryResult}},
\code{\link{allSummaryFunctions}}
}
