% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_functions.R
\name{which_are_constant}
\alias{which_are_constant}
\title{Identify constant columns}
\usage{
which_are_constant(data_set, keep_cols = NULL, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{keep_cols}{List of columns not to drop (list of character, default to NULL)}

\item{verbose}{Should the algorithm talk (logical, default to TRUE)}
}
\value{
List of column's indexes that are constant in the data_set set.
}
\description{
Find all the columns that are constant.
}
\details{
Algorithm is performing exponential search: it check constancy on row 1 to 10,
if it's not constant it stops, if it's constant then on 11 to 100 ... \cr
If you have a lot of columns than aren't constant, this function is way faster than a simple
\code{length(unique())}! The larger the data_set set is, the more interesting it is to use this function.
}
\examples{
# Let's load our data_set
data(tiny_messy_adult)

# Let's try our function
which_are_constant(tiny_messy_adult)
# Indeed it return constant the name of the constant column.
}
