% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqueValues.R
\name{uniqueValues}
\alias{uniqueValues}
\title{summaryFunction for unique values}
\usage{
uniqueValues(v, ...)
}
\arguments{
\item{v}{A variable (vector).}

\item{...}{Not in use.}
}
\value{
An object of class \code{summaryResult} with the following entries: 
\code{$feature} ("No. unique values") and \code{$result} (the number of unique 
values in \code{v}).
}
\description{
A \code{\link{summaryFunction}} type function, intended to be called from 
\code{\link{summarize}} to be called from \code{\link{summarize}}, which counts the
number of unique (excluding \code{NA}s) values in a variable.
}
\examples{
uniqueValues(c(1:3, rep(NA, 10), Inf, NaN))

}
\seealso{
\code{\link{summaryFunction}}, \code{\link{summarize}}, \code{\link{summaryResult}},
\code{\link{allSummaryFunctions}}
}
