% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthenticationManager.R
\docType{methods}
\name{getAuthSubject}
\alias{getAuthSubject}
\alias{getAuthSubject,AuthenticationManager-method}
\title{Get the authentication subject.}
\usage{
getAuthSubject(.Object, ...)

\S4method{getAuthSubject}{AuthenticationManager}(.Object, node)
}
\arguments{
\item{.Object}{an AuthenticationManager instance}

\item{...}{(Not yet used)}

\item{node}{A D1Node instance}
}
\value{
the DataONE Subject that is your client's identity
}
\description{
Get the authentication subject.
}
\details{
The authenticated user, aka 'subject' is retrieved from the authentication mechanism
currently being used, either an authentication token or an X.509 certificate. The \code{'node'}
argument is used to determine the authentication mechanism that is appropriate for the specified \code{'node'}.
For example, authentication tokens are supported on DataONE nodes that use the DataONE V2.0 API or higher, so if the 
node uses the V1 API, then only an X.509 certificate can be used.
}
