% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CertificateManager.R
\docType{methods}
\name{getCertLocation}
\alias{getCertLocation}
\alias{getCertLocation,CertificateManager-method}
\title{Get the file path on disk of the client certificate file.}
\usage{
getCertLocation(x, ...)

\S4method{getCertLocation}{CertificateManager}(x)
}
\arguments{
\item{x}{a CertificateManager instance}

\item{...}{(Not yet used)}
}
\value{
character the path to the certificate
}
\description{
Find the location of the client certificate, which is typically in a default
location on disk, unless the \code{'location'} slot has been set with a custom location for
the certificate.
}
\details{
The default  Globus Grid Security Infrastructure (GSI) location is \code{'/tmp/x509up_u${UID}'} 
on Unix or \code{'${tmpdir}/x509up_u${UID}'} on Windows or \code{'${tmpdir}/x509up_u${user.name}'} 
if \code{'${UID}'} is not defined.
}
