% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_sts_element_segment.R
\name{int_sts_element_segment}
\alias{int_sts_element_segment}
\title{Checks for element set}
\usage{
int_sts_element_segment(study_data, meta_data = "item_level")
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements, mandatory.}

\item{meta_data}{\link{data.frame} the data frame that contains metadata attributes of the study data, mandatory.}
}
\value{
a \link{list} with
\itemize{
\item \code{SegmentData}: data frame with the unexpected elements check results.
- \code{Segment}: name of the corresponding segment,
if applicable, \code{ALL} otherwise
\item \code{SegmentTable}: data frame with the unexpected elements check results, used for the data quality report.
- \code{Segment}: name of the corresponding segment,
if applicable, \code{ALL} otherwise
}
}
\description{
Depends on \code{dataquieR.ELEMENT_MISSMATCH_CHECKTYPE} option,
see there -- # TODO: Rind out, how to document and link
it here using \code{Roxygen}.
}
\details{
\link{Indicator}
}
\examples{
\dontrun{
study_data <- cars
meta_data <- dataquieR::prep_create_meta(VAR_NAMES = c("speedx", "distx"),
  DATA_TYPE = c("integer", "integer"), MISSING_LIST = "|", JUMP_LIST = "|",
  STUDY_SEGMENT = c("Intro", "Ex"))
options(dataquieR.ELEMENT_MISSMATCH_CHECKTYPE = "none")
int_sts_element_segment(study_data, meta_data)
options(dataquieR.ELEMENT_MISSMATCH_CHECKTYPE = "exact")
int_sts_element_segment(study_data, meta_data)
study_data <- cars
meta_data <- dataquieR::prep_create_meta(VAR_NAMES = c("speedx", "distx"),
  DATA_TYPE = c("integer", "integer"), MISSING_LIST = "|", JUMP_LIST = "|",
  STUDY_SEGMENT = c("Intro", "Intro"))
options(dataquieR.ELEMENT_MISSMATCH_CHECKTYPE = "none")
int_sts_element_segment(study_data, meta_data)
options(dataquieR.ELEMENT_MISSMATCH_CHECKTYPE = "exact")
int_sts_element_segment(study_data, meta_data)
study_data <- cars
meta_data <- dataquieR::prep_create_meta(VAR_NAMES = c("speed", "distx"),
  DATA_TYPE = c("integer", "integer"), MISSING_LIST = "|", JUMP_LIST = "|",
  STUDY_SEGMENT = c("Intro", "Intro"))
options(dataquieR.ELEMENT_MISSMATCH_CHECKTYPE = "none")
int_sts_element_segment(study_data, meta_data)
options(dataquieR.ELEMENT_MISSMATCH_CHECKTYPE = "exact")
int_sts_element_segment(study_data, meta_data)
}
}
