% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_remove_na_records.R
\name{util_remove_na_records}
\alias{util_remove_na_records}
\title{remove all records, that have at least one \code{NA} in any of the given variables}
\usage{
util_remove_na_records(study_data, vars = colnames(study_data))
}
\arguments{
\item{study_data}{the study data frame}

\item{vars}{the variables being checked for \code{NA}s}
}
\value{
modified study_data data frame
}
\description{
remove all records, that have at least one \code{NA} in any of the given variables
}
\examples{
\dontrun{
dta <- iris
dim(util_remove_na_records(dta))
dta$Species[4:6] <- NA
dim(util_remove_na_records(dta))
dim(util_remove_na_records(dta, c("Sepal.Length", "Petal.Length")))
}


}
\seealso{
Other data_management: 
\code{\link{util_assign_levlabs}()},
\code{\link{util_check_data_type}()},
\code{\link{util_check_group_levels}()},
\code{\link{util_compare_meta_with_study}()},
\code{\link{util_dichotomize}()},
\code{\link{util_merge_data_frame_list}()},
\code{\link{util_rbind}()},
\code{\link{util_replace_hard_limit_violations}()},
\code{\link{util_study_var2factor}()},
\code{\link{util_table_of_vct}()}
}
\concept{data_management}
\concept{missing}
\keyword{internal}
