% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{episodes}
\alias{episodes}
\title{List of episodes}
\format{
This data frame contains the following columns:
\describe{
\item{\code{era}}{"classic" or "revived"}
\item{\code{season_number}}{Season number}
\item{\code{serial_title}}{Serial title if available}
\item{\code{story_number}}{Story number}
\item{\code{episode_number}}{Episode number in season}
\item{\code{episode_title}}{Episode Title}
\item{\code{type}}{"episode" or "special"}
\item{\code{first_aired}}{Date the episode first aired in the U.K.}
\item{\code{production_code}}{Episode's production code if available}
\item{\code{uk_viewers}}{Number of U.K. viewers (millions)}
\item{\code{rating}}{Episode's rating}
\item{\code{duration}}{Episode's duration in minutes}
}
}
\source{
\url{https://en.wikipedia.org/wiki/List_of_Doctor_Who_episodes_(2005-present)}
}
\usage{
episodes
}
\description{
List of all episodes from the revived Doctor Who era (2005-present)
}
\examples{
library(dplyr)
episodes \%>\%
    filter(type == "special")
}
\keyword{datasets}
