% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{DeletePredictionExplanations}
\alias{DeletePredictionExplanations}
\title{Function to delete prediction explanations}
\usage{
DeletePredictionExplanations(project, predictionExplanationId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictionExplanationId}{character. Id of the prediction explanations.}
}
\value{
Logical TRUE and displays a message to the user if the delete
request was successful; otherwise an error message is displayed.
}
\description{
This function deletes prediction explanations specified by project and
predictionExplanationId.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModel(projectId, modelId)
  jobId <- RequestPredictionExplanations(model, datasetId)
  predictionExplanationId <- GetPredictionExplanationsMetadataFromJobId(projectId, jobId)$id
  DeletePredictionExplanations(projectId, predictionExplanationId)
}
}
