% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blueprints.R
\name{GetModelBlueprintChart}
\alias{GetModelBlueprintChart}
\title{Retrieve a model blueprint chart}
\usage{
GetModelBlueprintChart(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Unique alphanumeric identifier for the model of interest.}
}
\value{
List with the following two components:
\itemize{
  \item nodes. list each element contains information about one node
     of a blueprint : id and label.
  \item edges. Two column matrix, identifying blueprint nodes connections.
}
}
\description{
A model blueprint is a "pruned down" blueprint representing what was actually run for the model.
This is solely the branches of the blueprint that were executed based on the featurelist.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  GetModelBlueprintChart(projectId, modelId)
}
}
