% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StartAutopilot.R
\name{SetTarget}
\alias{SetTarget}
\title{Set the target variable (and by default, start the DataRobot Autopilot)}
\usage{
SetTarget(project, target, metric = NULL, weights = NULL,
  partition = NULL, mode = NULL, seed = NULL, positiveClass = NULL,
  blueprintThreshold = NULL, responseCap = NULL, recommenderUserId = NULL,
  recommenderItemId = NULL, quickrun = NULL, featurelistId = NULL,
  maxWait = 60)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{target}{Character string giving the name of the response variable
to be predicted by all project models.}

\item{metric}{Optional character string specifying the model fitting metric
to be optimized; a list of valid options for this parameter, which depends on
both project and target, may be obtained with the function GetValidMetrics.}

\item{weights}{Optional character string specifying the name of the column
from the modeling dataset to be used as weights in model fitting.}

\item{partition}{Optional S3 object of class 'partition' whose elements specify
a valid partitioning scheme.  See help for functions
CreateGroupPartition, CreateRandomPartition, CreateStratifiedPartition, and CreateUserPartition.}

\item{mode}{Optional, specifies the autopilot mode used to start the
modeling project; valid options are 'auto' (fully automatic,
the current DataRobot default, obtained when mode = NULL), 'semiauto', and 'manual'}

\item{seed}{Optional integer seed for the random number generator used in
creating random partitions for model fitting.}

\item{positiveClass}{Optional target variable value corresponding to a positive
response in binary classification problems.}

\item{blueprintThreshold}{Optional integer specifying the maximum time
(in hours) that any modeling blueprint is allowed to run before being
terminated.}

\item{responseCap}{Optional floating point value, between 0.5 and 1.0,
specifying a capping limit for the response variable. The default value
NULL corresponds to an uncapped response, equivalent to responseCap = 1.0.}

\item{recommenderUserId}{Optional character string, giving the name of the
data column containing user ID's (for recommender models only).}

\item{recommenderItemId}{Optional character string, giving the name of the data
column containing item ID's (for recommender models only).}

\item{quickrun}{Optional logcial variable; if TRUE then DR will perform
a quickrun, limiting the number of models evaluated during autopilot.}

\item{featurelistId}{Specifies which feature list to use. If NULL (default),
a default featurelist is used.}

\item{maxWait}{Specifies how many seconds to wait for the server to finish
analyzing the target and begin the modeling process. If the process takes
longer than this parameter specifies, execution will stop (but the server
will continue to process the request).}
}
\description{
This function sets the target variable for the project defined by
project, starting the process of building models to predict the response
variable target.  Both of these parameters - project and target - are
required and they are sufficient to start a modeling project with
DataRobot default specifications for the other 10 optional parameters.
}

