% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{datasource}
\alias{datasource}
\alias{datasource<-}
\title{Get/set the Source of the object.}
\usage{
datasource(x)

datasource(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{dataset::\link{dataset}}.}

\item{overwrite}{If the attributes should be overwritten. In case it is set
to \code{FALSE},it gives a warning with the current \code{datasource}
property instead of overwriting it. Defaults to \code{FALSE}.}

\item{value}{The \code{Source} as a character string of lengths one.}
}
\value{
The \code{Source} attribute as a character of length 1 is added to
\code{x}.
}
\description{
Get/set the optional \code{Source} property as an attribute to an
R object. Do not confuse with the base R \code{source()} function.
}
\details{
The \code{Source} is a related resource from which the described resource is
derived. See \href{https://purl.org/dc/elements/1.1/source}{dct:source}. In Datacite,
the source is described by a \code{relatedIdentifierType} with the property
\code{relationType="isDerivedFrom"}.
}
\examples{
datasource(iris_dataset) <- "https://doi.org/10.1111/j.1469-1809.1936.tb02137.x"
datasource(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{size}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
