% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_map_bimap.R
\name{bimap}
\alias{bimap}
\title{Create a new \code{bimap}}
\usage{
bimap(key.class = c("character", "numeric", "integer"),
  value.class = c("character", "numeric", "integer"))
}
\arguments{
\item{key.class}{the primitive class type of the keys}

\item{value.class}{the primitive class type of the values}
}
\value{
returns a new \code{bimap} object
}
\description{
Instantiates a new \code{\linkS4class{bimap}} object,
 i.e. an unordered collection of key-value pairs with mappings
 \deqn{f: keys -> values,}
 and
 \deqn{f: values -> keys.}
}
\examples{
 # create a bimap with character <-> character bi-mapping
 b <- bimap()

 # create a bimap with character <-> integer bi-mapping
 b <- bimap("character", "integer")

 # create a bimap with integer <-> integer bi-mapping
 b <- bimap("integer", "numeric")

}
