% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_insert.R, R/ds_deque.R, R/ds_heap.R,
%   R/ds_map_bimap.R, R/ds_map_unordered.R
\docType{methods}
\name{insert}
\alias{insert}
\alias{insert,deque,ANY,missing-method}
\alias{insert,deque,list,missing-method}
\alias{insert,heap,vector,vector-method}
\alias{insert,heap,vector,matrix-method}
\alias{insert,heap,vector,list-method}
\alias{insert,heap,vector,ANY-method}
\alias{insert,bimap,vector,vector-method}
\alias{insert,unordered_map,vector,vector-method}
\alias{insert,unordered_map,vector,list-method}
\alias{insert,unordered_map,vector,ANY-method}
\title{Add elements to an object}
\usage{
insert(obj, x, y)

\S4method{insert}{deque,ANY,missing}(obj, x)

\S4method{insert}{deque,list,missing}(obj, x)

\S4method{insert}{heap,vector,vector}(obj, x, y)

\S4method{insert}{heap,vector,matrix}(obj, x, y)

\S4method{insert}{heap,vector,list}(obj, x, y)

\S4method{insert}{heap,vector,ANY}(obj, x, y)

\S4method{insert}{bimap,vector,vector}(obj, x, y)

\S4method{insert}{unordered_map,vector,vector}(obj, x, y)

\S4method{insert}{unordered_map,vector,list}(obj, x, y)

\S4method{insert}{unordered_map,vector,ANY}(obj, x, y)
}
\arguments{
\item{obj}{object to insert into}

\item{x}{the values/keys to insert into}

\item{y}{values to be inserted which are required for some datastructures}
}
\value{
returns \code{obj} with inserted values
}
\description{
Adds keys or <key, value> pairs to an object and returns the
 object. Depending on the datastructure used, either only keys are required
 or pairs of <keys, values>. Insertion of elements with vectors, i.e. giving
 multiple arguments at the same time is faster than inserting elements
 iteratively.
}
\examples{

 # inserts values into a multimap
 m_map <- multimap()
 m_map <- insert(m_map, c("a", "b"), 1:2)
 m_map <- insert(m_map, c("a", "b"), list(1, list(a=1)))
 m_map["a"] <- rnorm(length(letters))
 m_map[c("a", "b", "c")] <- list(1, data.frame(a=2), environment())

 # inserts values into a fibonacci_heap
 f_heap <- fibonacci_heap("integer")
 f_heap <- insert(f_heap, 1:2, 1:2)
 f_heap[3:4] <- list(1, list(a=1))
 f_heap <- insert(f_heap, 5:6, list(data.frame(a=rnorm(3)), diag(2)))

 # inserts elements into a queue or stack
 s <- stack()
 s <- insert(s, list(1, vector(), list(3), data.frame(rnorm(3))))

}
