% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rotate.R
\name{data_rotate}
\alias{data_rotate}
\alias{data_transpose}
\title{Rotate a data frame}
\usage{
data_rotate(data, rownames = NULL, colnames = FALSE, verbose = TRUE)

data_transpose(data, rownames = NULL, colnames = FALSE, verbose = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{rownames}{Character vector (optional). If not \code{NULL}, the data frame's
rownames will be added as (first) column to the output, with \code{rownames}
being the name of this column.}

\item{colnames}{Logical or character vector (optional). If \code{TRUE}, the values
of the first column in \code{x} will be used as column names in the rotated data
frame. If a character vector, values from that column are used as column
names.}

\item{verbose}{Toggle warnings.}
}
\value{
A (rotated) data frame.
}
\description{
This function rotates a data frame, i.e. columns become rows and vice versa.
It's the equivalent of using \code{t()} but restores the \code{data.frame} class,
preserves attributes and prints a warning if the data type is
modified (see example).
}
\examples{
x <- mtcars[1:3, 1:4]

x

data_rotate(x)
data_rotate(x, rownames = "property")

# use values in 1. column as column name
data_rotate(x, colnames = TRUE)
data_rotate(x, rownames = "property", colnames = TRUE)

# warn that data types are changed
str(data_rotate(iris[1:4, ]))

# use either first column or specific column for column names
x <- data.frame(a = 1:5, b = 11:15, c = letters[1:5], d = rnorm(5))
data_rotate(x, colnames = TRUE)
data_rotate(x, colnames = "c")

}
\seealso{
\itemize{
\item Functions to rename stuff: \code{\link[=data_rename]{data_rename()}}, \code{\link[=data_rename_rows]{data_rename_rows()}}, \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}}, \code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate dataframes: \code{\link[=data_to_long]{data_to_long()}}, \code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to recode data: \code{\link[=data_rescale]{data_rescale()}}, \code{\link[=data_reverse]{data_reverse()}}, \code{\link[=data_cut]{data_cut()}}, \code{\link[=data_recode]{data_recode()}}, \code{\link[=data_shift]{data_shift()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=center]{center()}}, \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split and merge dataframes: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=data_select]{data_select()}}, \code{\link[=data_find]{data_find()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
