% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmine.R
\encoding{UTF-8}
\name{load_sigmine}
\alias{load_sigmine}
\title{SIGMINE - Mining Geographic Information System}
\usage{
load_sigmine(dataset = "sigmine_active", raw_data, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("sigmine_active")}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information the mines being explored legally in Brazil, including their location, status, product being mined and area in square meters etc. Survey is done at municipal and state level
}
\examples{
\dontrun{
# download state raw data
sigmine_active <- load_sigmine(
  dataset = "sigmine_active",
  raw_data = TRUE
)
}
}
