\name{aocc} 
\alias{aocc}
\alias{aocc.default}
\alias{plot.aocc}
\alias{aoc}
\title{
Analysis of concentration (AOC)
}
\description{
Given a two-dimensional matrix of vegetation data the function derives a contingency table of counts (scores presenc-absence transformed) based on input classification of rows (the vegetation releves) and columns (the species). The cells of the contingency table are then adjusted to equal weight, followed by correspondence analysis (\code{\link{cca}}). Concentration of counts is measured and an ordination plotted.
}
\usage{
aocc(veg, o.rgr, o.sgr,...)
aoc(veg, o.rgr, o.sgr)

\method{aocc}{default}(veg, o.rgr, o.sgr,...)
\method{plot}{aocc}(x,...)
}
\arguments{
  \item{veg}{
A data frame of vegetation releves (rows) by species (columns)
}
  \item{o.rgr}{
Group membership of rows given upon input
}
  \item{o.sgr}{
Group membership of columns given upon input
}
  \item{x}{
An object of class "aocc"
}
  \item{\dots}{
Further variables used for plotting
}
}
\details{
These input parameters are typically generated by functions clust() and
cutree() in the cluster package. See example below.
}
\value{
An output list of class "aocc" with at least the following items:

\item{rgrscores}{Ordination scores of releve groups}
\item{sgrscores}{Ordination scores of species groups}
\item{eigvar}{Eigenvalues of correspondence analysis}
\item{grand.total}{Grand total of contingency table}
\item{MSCC}{Mean square contingency coefficient, a measure of concentration}
\item{new.relorder}{Order of rows after ordering groups according to 1. axis}
\item{new.sporder}{Order of columns after ordering groups according to 1. axis}
\item{cont.table}{The contingency table}
}
\references{
Feoli, E. & Orloci, L. 1979. Analysis of
concentration and detection of underying factors in structured tables.
Vegetatio 40: 49-54.

Orloci, L. & Kenkel, N. 1985. Introduction to
Data Analysis. International Co-operative Publ. House, Burtonsville,
MD.

Wildi, O. 2013. Data Analysis in Vegetation Ecology. 2nd ed. Wiley-Blackwell, Chichester.
}
\author{
Otto Wildi
}
\note{
The analysis of lattice structure, described in some of the references, is not included in this function.
}
\examples{
# First, groups of releves are formed
require(vegan)
dr<- vegdist(nveg^0.5,method="bray")      # dr is distance matrix of rows
o.clr<- hclust(dr,method="ward")          # this is clustering
o.rgr<- cutree(o.clr,k=3)                 # 3 row groups formed
# Now I group the columns of nveg (the species)
# the same way as for rows
ds<- vegdist(t(nveg^0.25),method="euclid")
o.cls<- hclust(ds,method="ward")
o.sgr<- cutree(o.cls,k=4)                  # 4 column groups formed

o.aocc<- aocc(nveg,o.rgr,o.sgr)
plot(o.aocc)                               # double scatter plot
                                           # 3 row-, 4 column goups as points.

# If cluster analysis is not used but classification is input by row and 
# column to be processed by aocc():
o.rgr<- c(1,2,1,3,2,3,1,2,3,1,3)
o.sgr<- c(1,1,2,2,1,3,4,3,1,1,1,3,3,1,1,4,4,4,4,1,3)
o.aocc<- aocc(nveg,o.rgr,o.sgr)
plot(o.aocc)

}
\keyword{ multivariate }
\keyword{ array }
