\name{srank}         % DESCRIPTION OF FUNCTION srank, 10.12.2012
\alias{srank}
\alias{srank.default}
\alias{print.srank}
\alias{srank2}
\title{
Ranking species by IndVal or F-value
}
\description{
Given a vegetation data frame with grouped rows (releves) indicator value analysis (funcion \code{\link{indval}}) or analysis of variance (\code{\link{aoc}}) is performed on columns (species) and these are ordered by decreasing IndVal (function indval()) or F-value (aov()) accordingly.
}
\usage{
srank(veg, groups, method, y,...)
srank2(veg,groups,method,y)

\method{srank}{default}(veg, groups, method, y,...)
\method{print}{srank}(x,...)
}
\arguments{
  \item{veg}{
This is a vegetation data frame, releves are rows, species columns
}
  \item{groups}{
Group membership of rows (releves)
}
  \item{method}{
Either "indval" or "jancey"
}
  \item{y}{
Transformation of species scores: x'= x exp(y)
}
  \item{\dots}{
Further variables used for printing
}
  \item{x}{
A list of class "srank" generated by centroid
}
}
\value{
An object of class "srank" with at least the following items:

\item{ rank }{ A sequence of numbers, 1,2,3,...,p where p= number of species}
\item{ species.no }{ The corresponding species no. (i.e. the column no. }
\item{ species }{ The corresponding species names (taken from column names}
\item{ Indval }{ The corresponding indicator values (method "indval") }
\item{ F_value }{ The corresponding F-values (method "jancey") }
\item{ error.probability }{ The corresponding error probabilities }
}
\references{
Jancey, R.C. 1979. Species ordering on a variance criterion. Vegetatio 39: 59--63.

Wildi, O. 2013. Data Analysis in Vegetation Ecology. 2nd ed. Wiley-Blackwell, Chichester.
}
\author{
Otto Wildi
}
\examples{
# Starts with classifying releves by cluster analysis
dd<- vegdist(nveg^0.5,method="euclid")         # dd is distance matrix
o.clust<- hclust(dd,method="ward")             # clustering
groups<- as.factor(cutree(o.clust,k=3))        # forming 3 groups

# Applies ranking and prints ordered table of species (the columns)
o.srank<- srank(nveg,groups,method="jancey",y=0.5)
o.srank
}
\keyword{ arith }
\keyword{ multivariate }
