% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcSubtreeClade.r
\name{dcSubtreeClade}
\alias{dcSubtreeClade}
\title{Function to extract a subtree under a given clade from a phylo-formatted phylogenetic tree}
\usage{
dcSubtreeClade(phy, choose.node = NULL, choose.node.label = NULL,
verbose = T)
}
\arguments{
\item{phy}{an object of class 'phylo'}

\item{choose.node}{an integer specifying which internal node is chosen.
For an object of class 'phylo', the tree has built-in ID for internal
nodes, ranging from \eqn{Ntip+1} to \eqn{Ntip+Nnode}, where \eqn{Ntip}
and \eqn{Nnode} are the number of tips and internal nodes. Internal
nodes are indexed in a pre-ordered manner. The subtree under the given
interna node will be extracted}

\item{choose.node.label}{a character specifying which internal node is
chosen. For the tree with internal node labels, the extraction of
subtree can be done in this way}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
an object of class 'phylo'
}
\description{
\code{dcSubtreeClade} is supposed to extract a subtree under a given
clade from a phylo-formatted phylogenetic tree. In addition to the tree
in subject, another input is a built-in integer specifying an internal
node/clade of interest. Alternatively, the internal node of interest
can be given by its label (if there are internal node labels). As a
result, a subtree under a given clade is also represented as an object
of class 'phylo'.
}
\note{
If a valid 'choose.node' is given, then 'choose.node.label' will be
ignored.
}
\examples{
# 1) a newick tree without internal node labels
tree <- "(((t1:5,t2:5):2,(t3:4,t4:4):3):2,(t5:4,t6:4):6);"
phy <- ape::read.tree(text=tree)
phy
Ntip <- ape::Ntip(phy)
Nnode <- ape::Nnode(phy)
ape::plot.phylo(phy, type="p", use.edge.length=TRUE)
ape::nodelabels(node=Ntip+1:Nnode, col="red", bg="white")
# a subtree specified via a built-in internal node ID
subphy <- dcSubtreeClade(phy, choose.node=Ntip+2)
subphy
ape::plot.phylo(subphy, type="p", use.edge.length=TRUE)

# 2) a newick tree with internal node labels
tree <- "(((t1:5,t2:5)i3:2,(t3:4,t4:4)i4:3)i2:2,(t5:4,t6:4)i5:6)i1;"
phy <- ape::read.tree(text=tree)
phy
ape::plot.phylo(phy, type="p", use.edge.length=TRUE,
show.node.label=TRUE)
# a subtree specified via an internal node label
subphy <- dcSubtreeClade(phy, choose.node.label='i2')
subphy
ape::plot.phylo(subphy, type="p", use.edge.length=TRUE,
show.node.label=TRUE)
}
\seealso{
\code{\link{dcTreeConnectivity}}
}

