% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-wildtype_mutant_pnpp.R
\name{wells_mutant}
\alias{wells_mutant}
\title{Get mutant wells}
\usage{
wells_mutant(plate)
}
\arguments{
\item{plate}{A ddPCR plate.}
}
\value{
Character vector with well IDs of mutant wells
}
\description{
After a ddPCR plate of type \code{wildtype_mutant_pnpp} has been analyzed,
get the wells that were deemed as mutant.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$fam_positive_pnpp) \%>\% analyze
wells_mutant(plate)
}
}
\seealso{
\code{\link[ddpcr]{wildtype_mutant_pnpp}}\cr
\code{\link[ddpcr]{wells_wildtype}}
}
