%                               -*- Mode: Rd -*- 
% autosearch.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:01:29 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:41:43 2004
% Update Count    : 81
% Status          : Unknown, Use with caution!
% 

\name{autosearch}
\alias{autosearch}
\alias{heuristic}
\alias{gettable}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Greedy search}

\description{
  From initial network, does local perturbations to increase network score.
}

\usage{
autosearch(initnw,data,prior=jointprior(network(data)),maxiter=50,
           trylist= vector("list",size(initnw)),trace=TRUE,
           timetrace=TRUE,showban=FALSE,removecycles=FALSE) 

heuristic(initnw,data,prior=jointprior(network(data)),
          maxiter=100,restart=10,degree=size(initnw),
          trylist= vector("list",size(initnw)),trace=TRUE,
          timetrace=TRUE,removecycles=FALSE)
gettable(x)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{initnw}{an object of class \code{\link{network}}, from which the
    search is started. } 
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
 \item{maxiter}{an integer, which gives the maximum number of steps in the
   search algorithm.} 
  \item{restart}{an integer, which gives the number of times to perturb
    \code{initnw} and rerun the 
    search.}
  \item{degree}{an integer, which gives the degree of perturbation, see
    \code{\link{perturb}}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{trace}{a logical. If \code{TRUE}, plots the accepted networks
    during search.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
  \item{showban}{a logical passed to  the plot method for network
    objects. If
    \code{FALSE}, the banned arrows are not shown in the plots (if
    \code{trace} is \code{TRUE}).}
  \item{removecycles}{a logical. If \code{TRUE}, all networks explored in the
    search is returned, except for networks containing a cycle. If \code{FALSE}, all networks are returned, including
    cyclic networks.}
  \item{x}{an output object from a search.}
}

\details{
  In \code{autosearch}, a list of networks is in each step
  created with either one
  arrow added, one arrow deleted or one arrow turned (if a cycle is not
  generated). The network scores of all the proposal networks are
  calculated and the network with the highest score is chosen for the
  next step in the search. If no proposed network has a higher network
  score than the previous network, the search is terminated. The
  network with the highest network score is returned, along with a list
  containing all tried networks (depending on the value of \code{removecycles}).

  \code{heuristic} restarts by perturbing \code{initnw}
  \code{degree} times and calling 
  \code{autosearch} again. The number
  of restarts is given by the option \code{restart}.
}

\value{\code{autosearch} and \code{heuristic} returns a list with three
  elements, that may be accessed using \code{\link{getnetwork}},
  \code{\link{gettable}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}}, which gives the
  network with the highest score.}
  \item{table}{a table with all tried
    networks. If removecycles is \code{FALSE}, the networks may contain
    cycles. The table contains two columns: \code{model} with a 
    string representation of the model and \code{score} with the
    corresponding log network score. The table can be translated to a
    \code{\link{networkfamily}} using \code{\link{makenw}}.}  
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\seealso{\code{\link{perturb}}
  }


\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit,12)
fit       <- getnetwork(learn(fit,rats,fit.prior))
fit       <- getnetwork(insert(fit,2,1,rats,fit.prior))
fit       <- getnetwork(insert(fit,1,3,rats,fit.prior))
hisc      <- autosearch(fit,rats,fit.prior,trace=FALSE)
hisc      <- autosearch(fit,rats,fit.prior,trace=FALSE,removecycles=TRUE) # slower
plot(getnetwork(hisc))

hisc2     <- heuristic(fit,rats,fit.prior,restart=10,trace=FALSE)
plot(getnetwork(hisc2))
print(modelstring(getnetwork(hisc2)))
plot(makenw(gettable(hisc2),fit))
}

\keyword{models}
