% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_CPT.R
\name{make_CPT}
\alias{make_CPT}
\title{Make Conditional Probability tables using the likelihood method}
\usage{
make_CPT(parent_effects, parent_weights, b, child_prior,
  ranking_child = NULL, child_states = NULL, parent_names = NULL,
  parent_states = NULL)
}
\arguments{
\item{parent_effects}{list of vectors describing the effects of all parent node
states on the value of the child variable. For example, if parent 1 has
four states, the respective vector might look like this: c(3,1,0,0). This
would imply that the first state of the parent is strongly associated with
high values for the child, the second less strongly, and the 3rd and
4th value are associated with equally low values.}

\item{parent_weights}{weight factors for the parent nodes}

\item{b}{parameter for the strength of the parent's influence on
the child node. A value of 1 causes no response; 3 is quite strong.}

\item{child_prior}{prior distribution for the states of the child node.}

\item{ranking_child}{vector of length length(child_prior) containing rankings for
the child node states on a -1..1 scale. If this is null, evenly spaced rankings on
this -1..1 scale are assigned automatically.}

\item{child_states}{optional vector specifying the names of the child states.}

\item{parent_names}{optional vector specifying parent node names.}

\item{parent_states}{list of the same structure as parent_effects containing
names for all states of all parents.}
}
\value{
list of two data.frames: 1) Conditional Probability Table (CPT); 2) legend table
specifying which states of the parent nodes belong to which column in the CPT.
}
\description{
This function creates Conditional Probability Tables for
Bayesian Network nodes from parameters that (for complex nodes) can
be more easily elicited from experts than the full table. The function
uses the Likelihood method, as described by Sjoekvist S & Hansson F, 2013.
Tables are created from three the relative weights of all parents, rankings
for all parents, a parameter (b) for the sensitivity of the child node and
a prior distribution (for the child node).
}
\examples{

make_CPT(parent_effects=list(c(-1,1),c(-0.5,0,0.5)),
  parent_weights=c(3,1),b=1.5,child_prior=c(.2,.6,.2),child_states=c("a","b","c"))

test_CPT<-make_CPT(parent_effects=list(c(-1,3),c(-4,2),c(-2,3,4),c(1,2,3)),
                  parent_weights=c(1,1,1,1),b=2,child_prior=c(1,2,3,4,5),
                  child_states=c("a","b","c","d","e"),
                  parent_states=list(c("low","high"),c("A","B"),c(1,2,3),c("Hi","Lunch","Bye")))


}
\references{
Sjoekvist S & Hansson F, 2013. Modelling expert judgement into a Bayesian
Belief Network - a method for consistent and robust determination of conditional
probability tables. Master's thesis, Faculty of Engineering, Lund University;
http://lup.lub.lu.se/luur/download?func=downloadFile&recordOId=3866733&fileOId=3866740
}
\author{
Eike Luedeling
}
\keyword{"Bayesian}
\keyword{"Likelihood}
\keyword{CPT,}
\keyword{Method"}
\keyword{Network",}
