% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_bitmap-layer.R
\name{add_bitmap_layer}
\alias{add_bitmap_layer}
\title{Add a bitmap layer to the deckgl widget}
\usage{
add_bitmap_layer(deckgl, id = "h3-hexagon-layer", image = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{image}{image}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
Add a bitmap layer to the deckgl widget
}
\examples{
image <- paste0(
  "https://raw.githubusercontent.com/",
  "uber-common/deck.gl-data/master/",
  "website/sf-districts.png"
)
bounds <- c(-122.5190, 37.7045, -122.355, 37.829)

deck <- deckgl() \%>\%
  add_bitmap_layer(image = image, bounds = bounds) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
