% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tables.R
\name{load_tables}
\alias{load_tables}
\title{Load the Input-Output and Final Demand Tables: Depreciated Interface}
\usage{
load_tables(x, y)
}
\arguments{
\item{x}{the intermediate demand table, it has dimensions GN x GN (G = no. of country, N = no. of industries),
excluding the first row and the first column which contains the country names,
and the second row and second column which contain the industry names for each country.
In addition, an extra row at the end should contain final demand.}

\item{y}{the final demand table it has dimensions GN x MN,
excluding the first row and the first column which contains the country names,
the second column which contains the industry names for each country,
and second row which contains the five decomposed final demands (M).}
}
\value{
A 'decompr' class object.
}
\description{
This function loads the demand tables
and defines all variables for the decomposition. It is kept in the package for backward compatibility. New users should use \code{\link{load_tables_vectors}} instead.
}
\details{
Adapted from code by Fei Wang.
}
\seealso{
\code{\link{load_tables_vectors}}
}
\author{
Bastiaan Quast
}
