% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_SVHT_coef.R
\name{optimal_SVHT_coef}
\alias{optimal_SVHT_coef}
\title{Optimal Hard Threshold for Singular Values}
\usage{
optimal_SVHT_coef(beta, sigma_known = FALSE)
}
\arguments{
\item{beta}{A single value or a vector that represents aspect ratio m/n of the matrix to
be denoised. 0<\code{beta}<=1.}

\item{sigma_known}{A logical value. TRUE if noise level known, FALSE if unknown.}
}
\value{
Optimal location of hard threshold, up the median data singular value (sigma
unknown) or up to \code{sigma*sqrt(n)} (sigma known); a vector of the same dimension
as \code{beta}, where \code{coef[i]} is the coefficient corresponding to \code{beta[i]}.
}
\description{
A function for the calculation of the coefficient determining optimal
location of hard threshold for matrix denoising by singular values hard thresholding
when noise level is known or unknown. Recreation of MATLAB code by Matan Gavish and
David Donoho.
}
\references{
Gavish, M., & Donoho, D. L. (2014). The optimal hard threshold for singular
values is 4/sqrt(3). IEEE Transactions on Information Theory, 60(8), 5040-5053.
}
