% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.gp}
\alias{plot.gpvec}
\alias{plot.dgp2}
\alias{plot.dgp2vec}
\alias{plot.dgp3}
\alias{plot.dgp3vec}
\title{Plots object from \code{deepgp} package}
\usage{
\method{plot}{gp}(x, trace = NULL, predict = NULL, ...)

\method{plot}{gpvec}(x, trace = NULL, predict = NULL, ...)

\method{plot}{dgp2}(x, trace = NULL, hidden = NULL, predict = NULL, ...)

\method{plot}{dgp2vec}(x, trace = NULL, hidden = NULL, predict = NULL, ...)

\method{plot}{dgp3}(x, trace = NULL, hidden = NULL, predict = NULL, ...)

\method{plot}{dgp3vec}(x, trace = NULL, hidden = NULL, predict = NULL, ...)
}
\arguments{
\item{x}{object of class \code{gp}, \code{gpvec}, \code{dgp2}, 
\code{dgp2vec}, \code{dgp3}, or \code{dgp3vec}}

\item{trace}{logical indicating whether to generate trace plots (default is
TRUE if the object has not been through \code{predict})}

\item{predict}{logical indicating whether to generate posterior predictive 
plot (default is TRUE if the object has been through \code{predict})}

\item{...}{N/A}

\item{hidden}{logical indicating whether to generate plots of hidden layers
(two or three layer only, default is FALSE)}
}
\description{
Acts on a \code{gp}, \code{gpvec}, \code{dgp2}, \code{dgp2vec},
    \code{dgp3}, or \code{dgp3vec} object.  
    Generates trace plots for outer log likelihood, length scale,
   and nugget hyperparameters.
    Generates plots of hidden layers for one-dimensional inputs.  Generates
    plots of the posterior mean and estimated 90\% prediction intervals for 
    one-dimensional inputs; generates heat maps of the posterior mean and 
    point-wise variance for two-dimensional inputs.
}
\details{
Trace plots are useful in assessing burn-in.  Hidden layer plots 
    are colored on a gradient - red lines represent earlier iterations and 
    yellow lines represent later iterations - to help assess burn-in of the 
    hidden layers.  These plots are meant to help in model fitting and 
    visualization.
}
\examples{
# See "fit_one_layer", "fit_two_layer", or "fit_three_layer"
# for an example

}
