/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;

public class GraphWalk<V, E>
implements GraphPath<V, E> {
    protected Graph<V, E> graph;
    protected List<V> vertexList;
    protected List<E> edgeList;
    protected V startVertex;
    protected V endVertex;
    protected double weight;

    public GraphWalk(Graph<V, E> graph, V startVertex, V endVertex, List<E> edgeList, double weight) {
        this(graph, startVertex, endVertex, null, edgeList, weight);
    }

    public GraphWalk(Graph<V, E> graph, List<V> vertexList, double weight) {
        this((Graph<Object, E>)graph, (vertexList.isEmpty() ? null : (V)vertexList.get(0)), (vertexList.isEmpty() ? null : (V)vertexList.get(vertexList.size() - 1)), (List<Object>)vertexList, null, weight);
    }

    public GraphWalk(Graph<V, E> graph, V startVertex, V endVertex, List<V> vertexList, List<E> edgeList, double weight) {
        if (vertexList == null && edgeList == null) {
            throw new IllegalArgumentException("Vertex list and edge list cannot both be null!");
        }
        this.graph = graph;
        this.startVertex = startVertex;
        this.endVertex = endVertex;
        this.vertexList = vertexList;
        this.edgeList = edgeList;
        this.weight = weight;
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public V getStartVertex() {
        return this.startVertex;
    }

    @Override
    public V getEndVertex() {
        return this.endVertex;
    }

    @Override
    public List<E> getEdgeList() {
        return this.edgeList != null ? this.edgeList : GraphPath.super.getEdgeList();
    }

    @Override
    public List<V> getVertexList() {
        return this.vertexList != null ? this.vertexList : GraphPath.super.getVertexList();
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public int getLength() {
        if (this.edgeList != null) {
            return this.edgeList.size();
        }
        if (this.vertexList != null && !this.vertexList.isEmpty()) {
            return this.vertexList.size() - 1;
        }
        return 0;
    }

    public String toString() {
        if (this.vertexList != null) {
            return this.vertexList.toString();
        }
        return this.edgeList.toString();
    }
}

