% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_tbl.R
\name{morph_tbl}
\alias{morph_tbl}
\title{Generating a Morphological Delimitation Table}
\usage{
morph_tbl(labels, sppVector, delimname = "morph")
}
\arguments{
\item{labels}{Vector of unique sequence ID labels.}

\item{sppVector}{Vector of corresponding morphological species delimitation groups.}

\item{delimname}{Character. String to rename the delimitation method in the table. Default to 'morph'.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{morph_tbl()} returns species partition hypothesis estimated from a prior taxonomic identifications supplied by the user.
}
\details{
\code{morph_tbl()} uses information in a species name vector to label each unique sample with a number corresponding to this name.
}
\examples{

# create a tibble
morph_df <- morph_tbl(
  labels = geophagus_info$gbAccession,
  sppVector = geophagus_info$scientificName
)

# check
morph_df

}
\author{
Rupert A. Collins
}
