% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_ptr_stats.R
\name{get_eptr_stats}
\alias{get_eptr_stats}
\title{Generate a variety of stats on PTR estimates for a given dataset}
\usage{
get_eptr_stats(X, iterations = 30)
}
\arguments{
\item{X}{cov3 dataframe}

\item{iterations}{number of iterations to run}
}
\value{
named list of stats on PTR estimates
\itemize{
\item all_sd: standard deviation of PTR estimates from all method
\item all_mean: mean of PTR estimates from all method
\item contigs_sd: standard deviation of PTR estimates from contigs method
\item contigs_mean: mean of PTR estimates from contigs method
\item samples_sd: standard deviation of PTR estimates from samples method
\item samples_mean: mean of PTR estimates from samples method
}
}
\description{
Generate a variety of stats on PTR estimates for a given dataset
}
\examples{
stats <- get_eptr_stats(max_bin_001[max_bin_001$sample \%in\% c('Akk0_001', 'Akk1_001'), ], 2)
stats

}
