% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branches_attr_by.R
\name{branches_attr_by_lists}
\alias{branches_attr_by_lists}
\title{Change col/lwd/lty of branches from the root down to clusters defined by list of labels of respective members}
\usage{
branches_attr_by_lists(dend, lists, TF_values = c(2, 1), attr = c("col",
  "lwd", "lty"), ...)
}
\arguments{
\item{dend}{a dendrogram dend}

\item{lists}{a list where each element contains the labels of members in selected nodes 
down to which the branches shall be adapted}

\item{TF_values}{a two dimensional vector with the TF_values to use in case a branch fulfills the condition (TRUE)
and in the case that it does not (FALSE). Defaults are 2/1 for col, lwd and lty.
(so it will insert the first value, and will not change all the FALSE cases)}

\item{attr}{a character with one of the following values: col/lwd/lty}

\item{...}{ignored.}
}
\value{
A dendrogram with modified branches (col/lwd/lty).
}
\description{
The user supplies a dend, lists, and type of condition (all/any), and TF_values
And the function returns a dendrogram with branches col/lwd/lty accordingly
}
\examples{
\dontrun{

library(dendextend)

set.seed(23235)
ss <- sample(1:150, 10 )

# Getting the dend dend
dend <- iris[ss,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend \%>\% plot

# define a list of nodes
L <- list(c("109", "123", "126", "145"), "29", c("59", "67", "97"))
dend \%>\% 
   branches_attr_by_lists(L) \%>\%
   plot

# choose different color, and also change lwd and lty 
dend \%>\% 
   branches_attr_by_lists(L, TF_value = "blue") \%>\%
   branches_attr_by_lists(L, attr = "lwd", TF_value = 4) \%>\%
   branches_attr_by_lists(L, attr = "lty", TF_value = 3) \%>\%
   plot
}
}
\seealso{
\link{branches_attr_by_labels}
}
