% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataGeneratingFunction.R
\name{dat.sim.reg.comp.risks}
\alias{dat.sim.reg.comp.risks}
\title{Data generation function for competing risks data}
\usage{
dat.sim.reg.comp.risks(
  n,
  par,
  iseed,
  s,
  conf,
  Zbin,
  Wbin,
  type.cov,
  A.upper = 15
)
}
\arguments{
\item{n}{The sample size of the generated data set.}

\item{par}{List of parameter vectors for each component of the transformation
model.}

\item{iseed}{Random seed.}

\item{s}{The number of competing risks. Note that the given parameter vector
could specify the parameters for the model with more than s competing risks,
but in this case only the first s sets of parameters will be considered.}

\item{conf}{Boolean value indicating whether the data set should contain
confounding.}

\item{Zbin}{Indicator whether the confounded variable is binary
\code{Zbin = 1} or not \code{Zbin = 0}. If \code{conf = FALSE}, this
variable is ignored.}

\item{Wbin}{Indicator whether the instrument is binary (\code{Zbin = 1}) or
not \code{Zbin = 0}.}

\item{type.cov}{Vector of characters "c" and "b", indicating which exogenous
covariates should be continuous \code{"c"} or binary \code{"b"}.}

\item{A.upper}{The upper bound on the support of the administrative censoring
distribution. This can be used to control for the amount of administrative
censoring in the data. Default is \code{A.upper = 15}. \code{A.upper = NULL}
will return a data set without administrative censoring.}
}
\value{
A generated data set
}
\description{
This function generates competing risk data that can be used in
simulation studies.
}
