% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asiangeomavg.R
\name{geomavgprice}
\alias{geomavgprice}
\title{Geometric average price}
\usage{
geomavgprice(s, k, v, r, tt, d, m, cont=FALSE)
}
\arguments{
\item{s}{Stock price}

\item{k}{Strike price of the option. In the case of average strike
options, \code{k/s} is the multiplier for the average}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{m}{Number of prices in the average calculation}

\item{cont}{Boolean which when TRUE denotes continuous averaging}
}
\value{
Call and put prices as a vector
}
\description{
Pricing functions for European Asian options based on
    geometric averages. \code{geomavgprice} and
    \code{geomavgstrike} compute analytical prices of geometric
    Asian options using the modified Black-Scholes
    formula.

Prices of geometric average-price call and put options
}
\details{
Geometric average asian options
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; m=3;
geomavgprice(s, k, v, r, tt, d, m)

}
\seealso{
Other Asian: \code{\link{arithasianmc}},
  \code{\link{arithavgpricecv}}, \code{\link{geomasianmc}},
  \code{\link{geomavgstrike}}
}

