% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwidth_bootstrap.R
\name{bwidth_confint}
\alias{bwidth_confint}
\title{Bootstrapping Confidence Intervals for Locally Weighted Regression Bandwidths}
\usage{
bwidth_confint(
  nonpar_model,
  blocklen = NULL,
  npaths = 1000,
  parallel = TRUE,
  num_cores = future::availableCores() - 1,
  ...
)
}
\arguments{
\item{nonpar_model}{the object with the nonparametric trend and seasonality
estimation results returned by for example the function 
\code{\link{deseats}}.}

\item{blocklen}{a numerical vector of length one that indicates the average 
block length to be drawn from the detrended series; the default is 
\code{NULL}, which means \code{8} for quarterly and \code{24} for monthly 
data; selecting a suitable expected blocklength and checking the sensitivity 
of the blocklength are left for the user.}

\item{npaths}{a numeric vector of length one that indicates the number of
bootstrap paths; the default is \code{npaths = 1000}.}

\item{parallel}{a logical vector of length one that indicates whether or 
not to employ parallel programming for the resampling and the subsequently 
data-driven bandwidth estimations from the bootstrapped samples; the default 
is \code{patrallel = TRUE}.}

\item{num_cores}{a numeric vector of length one that indicates the number of
CPU cores to use for parallel programming, if \code{parallel = TRUE}; the 
default is \code{num_cores = future::availableCores() - 1}.}

\item{...}{further arguments to pass to \code{\link{deseats}}.}
}
\value{
A list with the following elements is returned.
\describe{
\item{\code{conf}}{A vector with named elements that gives the original 
bandwidth estimate as well as the bootstrapped bounds of the 95 and 
99 percent confidence intervals of the bandwidth.}
\item{\code{bwidth_estimates}}{a vector with all the obtained bandwidths 
for the bootstrapped series.}
\item{\code{se_bwidth}}{the sample standard deviation of 
\code{bwidth_estimates}.}
}
}
\description{
A stationary block bootstrap is applied to resample from a time 
series that was decomposed into a trend, a seasonal component and a 
remainder by means of data-driven local polynomial regression with 
automatically selected bandwidth. Bandwidth re-estimation from each 
bootstrapped sample results in confidence bounds for the 
bandwidth.
}
\details{
Confidence bounds for the bandwidth in local polynomial regression 
for identifying the trend in a trend-stationary short-memory time 
series are obtained via a block bootstrap, which ensures that no 
specific model assumptions are required for the detrended series.

This function makes use of the \code{future} parallel programming 
framework to ensure exactly the same results regardless of whether
sequential or parallel programming, and then also regardless of
the number of workers, is employed.
}
\examples{
\donttest{
xt <- log(EXPENDITURES)
est <- deseats(xt, set_options(order_poly = 3))
conf <- bwidth_confint(est, npaths = 200, num_cores = 2)
conf
}

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
