% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-hfilter.R
\name{fitted,hfilter-method}
\alias{fitted,hfilter-method}
\alias{residuals,hfilter-method}
\title{Fitted Components of the Hamilton Filter}
\usage{
\S4method{fitted}{hfilter}(object, ...)

\S4method{residuals}{hfilter}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"hfilter"}, i.e. generated by a 
call to \code{\link{hamilton_filter}}.}

\item{...}{currently without further use; implemented for compatibility.}
}
\value{
A time series object of class \code{"ts"} is returned.
}
\description{
Obtain either fitted values or residuals from a fitted Hamilton filter.
}
\details{
Obtain the fitted and the residual values from the result of a fitted 
Hamilton filter. The name of the method indicates, what is returned.
}
\examples{
est <- hamilton_filter(log(EXPENDITURES))
residuals(est)
fitted(est)

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
