% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/det1.R
\name{det1}
\alias{det1}
\title{Density Estimation for Univariate Data Based on Distribution Element Trees}
\usage{
det1(dta, mode = 2, bounds = c(0, 0), alpha = 0.001, main = NULL,
  dtalim = Inf, cores = 1)
}
\arguments{
\item{dta}{vector with data}

\item{mode}{order of distribution elements applied, default is \code{mode = 2}. Use \code{+/-1} for constant or \code{+/-2} for linear elements. \code{mode > 0} and \code{mode < 0} lead to equal-size and -score splits, respectively, in the element-refinement process.}

\item{bounds}{\code{c(lb,ub)}, where \code{lb} and \code{ub} are lower and upper bounds of the probability space. If both bounds are set to 0 (default), the bounds are determined based on the data \code{dta}.}

\item{alpha}{significance level for goodness-of-fit testing in element refinement or splitting process. Default is \code{alpha = 1.0e-3}.}

\item{main}{an overall plot title, see \code{\link[graphics]{title}}.}

\item{dtalim}{allows to limit the number of samples used in tests guiding the element splitting process. Default is \code{dtalim = Inf}, which corresponds to using all available samples, see \code{\link{det.construct}}.}

\item{cores}{number of cores for parallel tree construction. Default is \code{1} for serial construction, see \code{\link{det.construct}}.}
}
\description{
One-dimensional piecewise linear or constant probability density estimator based on distribution element trees (DETs).
}
\examples{
require(stats)
det1(rbeta(5e5, shape1 = 1.05, shape2 = 0.8), mode = -1,
     bounds = c(-0.1,1.1), main = "beta, const. elements, equal-scores splits")
x <- seq(-0.1,1.1,0.005); lines(x, dbeta(x,shape1 = 1.05,shape2 = 0.8), col = "red")
det1(rbeta(5e5, shape1 = 1.05, shape2 = 0.8), mode = -2,
     bounds = c(-0.1,1.1), main = "beta, linear elements, equal-scores splits")
x <- seq(-0.1,1.1,0.005); lines(x, dbeta(x,shape1 = 1.05,shape2 = 0.8), col = "red")
det1(rnorm(5e5), mode = 2, cores = 1, main = "Gaussian, linear elements, equal-size splits")
x <- seq(-5,5,0.05); lines(x, dnorm(x), col = "red")
det1(runif(5e5), mode = 1, bounds = c(-0.1,1.1),
     main = "uniform, const. elements, equal-size splits")
x <- seq(-0.1,1.1,0.005); lines(x, dunif(x), col = "red")
}
