% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{hf_lines}
\alias{hf_lines}
\title{Produce CHUR and DM lines}
\usage{
hf_lines(range = c(0, 4560), plot_type = "ehf", constants)
}
\arguments{
\item{range}{range over which to calculate lines}

\item{plot_type}{'ehf' = epsilon-Hf; any thing else gives 176/177Hf}

\item{constants}{vector of constants which must be in the order
decay constant 176Lu, 176/177Hf CHUR, 176Lu/177Hf CHUR, 176/177Hf DM and
176Lu/177Hf DM}
}
\description{
Calculate CHUR and DM lines used for epsilon-Hf vs. age and 176/177Hf vs. age
plots.
}
\references{
Griffin, W., Pearson, N., Belousova, E., Jackson, S., van
Achterbergh, E., O'Reilly, S. and Shee, S. 2000. The Hf isotope composition
of cratonic mantle:
LAM-MC-ICPMS analysis of zircon megacrysts in kimberlites.
Geochimica et Cosmochimica Acta 64(1), 133-147.

Soderlund, U., Jonathan Patchett, P., Vervoort, J.D. and Isachsen
C.E. 2004. The 176Lu decay constant determined by Lu^Hf and U^Pb isotope
systematics of Precambrian mafic intrusions. Earth and Planetary Science
Letters 219, 311-324.

Bouvier, A., Vervoort, J.D. and Jonathan Patchett P. 2008. The
Lu-Hf and Sm-Nd isotopic composition of CHUR: Constraints from unequilibrated
chondrites and implications for the bulk composition of terrestrial planets.
Earth and Planetary Science Letters 273, 48-57.
}

