% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{beta_16}
\alias{beta_16}
\title{Beta2 equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\usage{
beta_16
}
\description{
Yin, X., Kropff, M.J., McLaren, G., and Visperas, R.M. (1995) A nonlinear model for crop
  development as a function of temperature. Agricultural and Forest Meteorology 77(1): 1-16.

Shi, P. J., Chen, L., Hui, C., & Grissino-Mayer, H. D. (2016). Capture the time when
plants reach their maximum body size by using the beta sigmoid growth equation. Ecological Modelling,
320, 177-181.

Shi, P. J., Reddy, G. V., Chen, L., and Ge, F. (2015). Comparison of thermal performance
equations in describing temperature-dependent developmental rates of insects: (I) empirical models.
Annals of the Entomological Society of America, 109(2), 211-215.
}
\details{
Equation:
\deqn{rT = rm * (\frac{T2 - T}/{T2 - Tm}) * (\frac{T - T1}/{Tm - T1})^{\frac{Tm - T1}/{T2 - Tm}}}{%
      rT = rm * (T2 - T)/(T2 - Tm) * ((T - T1)/(Tm - T1))^((Tm - T1)/(T2 - Tm))}

where rT is the development rate, T the temperature, T1, T2,
and Tm the model parameters.
}
\references{
\doi{10.1016/j.ecolmodel.2015.09.012}
}
\keyword{datasets}
