% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/create.r
\name{create}
\alias{create}
\alias{setup}
\title{Creates a new package, following all devtools package conventions.}
\usage{
create(path, description = getOption("devtools.desc"), check = FALSE,
  rstudio = TRUE)

setup(path = ".", description = getOption("devtools.desc"), check = FALSE,
  rstudio = TRUE)
}
\arguments{
\item{path}{location to create new package.  The last component of the path
will be used as the package name.}

\item{description}{list of description values to override default values or
add additional values.}

\item{check}{if \code{TRUE}, will automatically run \code{\link{check}}}

\item{rstudio}{Create an Rstudio project file?
(with \code{\link{use_rstudio}})}
}
\description{
Similar to \code{\link{package.skeleton}}, except that it only creates
the standard devtools directory structures; it doesn't try and create
source code and data files by inspecting the global environment.
}
\details{
\code{create} requires that the directory doesn't exist yet; it will be
created but deleted upon failure. \code{setup} assumes an existing
directory from which it will infer the package name.
}
\examples{
\dontrun{
# Create a package using all defaults:
path <- file.path(tempdir(), "myDefaultPackage")
create(path)

# Override a description attribute.
path <- file.path(tempdir(), "myCustomPackage")
my_description <- list("Maintainer" =
  "'Yoni Ben-Meshulam' <yoni@opower.com>")
create(path, my_description)
}
}
\seealso{
Text with \code{\link{package.skeleton}}
}

