% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausible_values.R
\name{plausible_values}
\alias{plausible_values}
\title{Draw plausible values}
\usage{
plausible_values(dataSrc, parms = NULL, predicate = NULL,
  covariates = NULL, nPV = 1, use_draw = NULL,
  prior.dist = c("normal", "mixture"), merge_within_persons = FALSE)
}
\arguments{
\item{dataSrc}{a connection to a dexter database, a matrix, or a data.frame with columns: person_id, item_id, item_score}

\item{parms}{An object returned by function \code{fit_enorm} containing parameter estimates. If parms are provided, item parameters are condidered known. 
If parms = NULL, plausible values are marginalized over the posterior distribution of the item parameters and uncertainty of the item parameters is taken into account.}

\item{predicate}{an expression to filter data. If missing, the function will use 
all data in dataSrc}

\item{covariates}{name or a vector of names of the variables to group the populations used to improve the prior.
A covariate must be a discrete person property (e.g. not a float) that indicates nominal categories, e.g. gender or school.
If dataSrc is a data.frame, it must contain the covariate.}

\item{nPV}{Number of plausible values to draw per person.}

\item{use_draw}{When the ENORM was fitted with a Gibbs sampler, this specifies the use of a particular sample of item parameters used to generate the plausibe value(s). If NULL, the posterior means are used. If outside range, the last iteration will be used.}

\item{prior.dist}{use a normal prior or a mixture of two normals
recognised automatically),}

\item{merge_within_persons}{If a person took multiple booklets, this indicates
whether plausible values are generated per person (TRUE) or per booklet (FALSE)}
}
\value{
A data.frame with columns booklet_id, person_id, booklet_score and nPV plausible values
named PV1...PVn.
}
\description{
Draws plausible values based on test scores
}
\examples{
db = start_new_project(verbAggrRules, ":memory:", 
   person_properties=list(gender="<unknown>"))
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)

f=fit_enorm(db)
pv_M=plausible_values(db,f,(mode=="Do")&(gender=="Male"))
pv_F=plausible_values(db,f,(mode=="Do")&(gender=="Female"))

par(mfrow=c(1,2))

plot(ecdf(pv_M$PV1), 
   main="Do: males versus females", xlab="Ability", col="red")
lines(ecdf(pv_F$PV1), col="green")
legend(-2.2,0.9, c("female", "male") , 
   lty=1, col=c('green', 'red'), bty='n', cex=.75)

pv_M=plausible_values(db,f,(mode=="Want")&(gender=="Male"))
pv_F=plausible_values(db,f,(mode=="Want")&(gender=="Female"))

plot(ecdf(pv_M$PV1), 
   main="Want: males versus females", xlab=" Ability", col="red")
lines(ecdf(pv_F$PV1),col="green")
legend(-2.2,0.9, c("female", "male") , 
   lty=1, col=c('green', 'red'), bty='n', cex=.75)
   
close_project(db)    

}
\references{
Marsman, M., Maris, G., Bechger, T. M., and Glas, C.A.C. (2016) What can we learn from plausible values? 
Psychometrika. 2016; 81: 274-289. See also the vignette.
}
