% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enorm.R
\name{coef.prms}
\alias{coef.prms}
\title{extract enorm item parameters}
\usage{
\method{coef}{prms}(object, hpd = 0.95, what = c("items", "var", "posterior"), ...)
}
\arguments{
\item{object}{an enorm parameters object, generated by the function \code{\link{fit_enorm}}}

\item{hpd}{width of Bayesian highest posterior density interval around mean_beta, 
value must be between 0 and 1, default is 0.95}

\item{what}{which coefficients to return. Defaults to `items` (the item parameters). Can also be `var` for the 
variance-covariance matrix (CML only) or `posterior` for all draws of the item parameters (Bayes only)}

\item{...}{further arguments to coef are ignored}
}
\value{
Depends on the calibration method and the value of 'what'. For 'items'#' 

\describe{
\item{CML}{a data.frame with columns: item_id, item_score, beta, SE_beta}
\item{Bayes}{a data.frame with columns: item_id, item_score, mean_beta, SD_beta, <hpd_b_left>, <hpd_b_right>}
}

The posterior distribution and variance covariance matrix are returned as matrices.
}
\description{
extract enorm item parameters
}
