% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{create_mst_test}
\alias{create_mst_test}
\title{Define a new multi stage test}
\usage{
create_mst_test(
  db,
  test_design,
  routing_rules,
  test_id,
  routing = c("all", "last")
)
}
\arguments{
\item{db}{output of \code{\link{open_mst_project}} or \code{\link{create_mst_project}}}

\item{test_design}{data.frame with columns item_id, module_id, item_position}

\item{routing_rules}{output of \code{\link{mst_rules}}}

\item{test_id}{id of the mst test}

\item{routing}{all or last routing (see details)}
}
\description{
Before you can enter data, dexterMST needs to know the design of your test.
}
\details{
In dexterMST we use the following terminology:
\describe{
\item{test}{collection of modules and rules to go from one module to the other.
A test must have one starting module}
\item{booklet}{a specific path through a mst test.}
\item{module}{ a block of items that is always administered together. Each item has a specific position in a module.}
\item{routing rules}{rules to go from one module to another based on score on the current and possibly previous modules}
 }
 
 Additionally, there are two possible types of routing:
\describe{
\item{all}{the routing rules are based on the sum of the current and previous modules}
\item{last}{the routing rules are based only on the current module}
}
The type of routing must be defined for a test as a whole so it is not possible to mix routing types. 
In CML (as opposed to MML) the routing rules are actually used in the calibration so it
is important they are correctly specified. DexterMST includes multiple checks, 
both when defining the test and when entering data, 
to make sure your routing rules are valid and your data conform to them.
}
\examples{
# extended example
# we: 
# 1) define an mst design
# 2) simulate mst data
# 3) create a project, enter scoring rules and define the MST test
# 4) do an analysis

library(dplyr)

items = data.frame(item_id=sprintf("item\%02i",1:70), item_score=1, delta=sort(runif(70,-1,1)))

design = data.frame(item_id=sprintf("item\%02i",1:70),
                    module_id=rep(c('M4','M2','M5','M1','M6','M3', 'M7'),each=10))

routing_rules = routing_rules = mst_rules(
 `124` = M1[0:5] --+ M2[0:10] --+ M4, 
 `125` = M1[0:5] --+ M2[11:15] --+ M5,
 `136` = M1[6:10] --+ M3[6:15] --+ M6,
 `137` = M1[6:10] --+ M3[16:20] --+ M7)

theta = rnorm(3000)

dat = sim_mst(items, theta, design, routing_rules,'all')
dat$test_id='sim_test'
dat$response=dat$item_score


scoring_rules = data.frame(
  item_id = rep(items$item_id,2), 
  item_score= rep(0:1,each=nrow(items)),
  response= rep(0:1,each=nrow(items))) # dummy respons
  

db = create_mst_project(":memory:")
add_scoring_rules_mst(db, scoring_rules)

create_mst_test(db,
                test_design = design,
                routing_rules = routing_rules,
                test_id = 'sim_test',
                routing = "all")

add_response_data_mst(db, dat)


design_plot(db)

f = fit_enorm_mst(db)

head(coef(f))

abl = ability(get_responses_mst(db), f) \%>\%
   inner_join(tibble(person_id=as.character(1:3000), theta.sim=theta), by='person_id')

plot(abl$theta, abl$theta.sim)   

abl = filter(abl, is.finite(theta))

cor(abl$theta, abl$theta.sim)

}
