% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfrr.R
\name{dfrr}
\alias{dfrr}
\title{Dichotomized Functional Response Regression (dfrr)}
\usage{
dfrr(
  formula,
  yind = NULL,
  data = NULL,
  ydata = NULL,
  method = c("REML", "ML"),
  rangeval = NULL,
  basis = NULL,
  times_to_evaluate = NULL,
  ...
)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}" (or one that can be coerced to that class with \code{as.formula}:
a symbolic description of the model to be fitted.}

\item{yind}{a vector with length equal to the number of columns of the matrix of functional
responses giving the vector of evaluation points \eqn{(t_1,...,t_{G})}.
If not supplied, \code{yind} is set to \code{1:ncol(<response>)}.}

\item{data}{an (optional) \code{data.frame} containing the covariate data.
the variable terms will be searched from the columns of \code{data},
covariates also can be read from the workspace if it is not available in \code{data}.}

\item{ydata}{an (optional) \code{data.frame} consists of three columns \code{.obs}, \code{.index} and \code{.value},
supplying the functional responses that are not observed on a regular grid.
ydata must be provided if the sampling design is irregular.}

\item{method}{detrmines the estimation method of functional parameters. Defaults to "\code{REML}" estimation.}

\item{rangeval}{an (optional) vector of length two, indicating the lower and upper limit of the domain of
latent functional response. If not specified, it will set by minimum and maximum of \code{yind} or \code{.index} column of \code{ydata}.}

\item{basis}{an (optional) object of class \code{'basisfd'}. Defaults to cubic bspline basis.}

\item{times_to_evaluate}{a numeric vector indicating the set of time points for evaluating the functional regression coefficients and principal components.}

\item{...}{other arguments that can be passed to the inner function \code{AMCEM}.}
}
\value{
The output is a \code{dfrr}-object, which then can be injected into other methods/functions
 to postprocess the fitted model, including:
 \code{\link{coef.dfrr}},\code{\link{fitted.dfrr}}, \code{\link{basis}}, \code{\link{residuals.dfrr}}, \code{\link{predict.dfrr}},
  \code{\link{fpca}}, \code{\link{summary.dfrr}}, \code{\link{model.matrix.dfrr}},
  \code{\link{plot.coef.dfrr}}, \code{\link{plot.fitted.dfrr}}, \code{\link{plot.residuals.dfrr}},
  \code{\link{plot.predict.dfrr}}, \code{\link{plot.fpca.dfrr}}
}
\description{
Implementing Function-on-Scalar Regression model, in which the response function
 is dichotomized and observed sparsely.
 This function fits the dichotomized functional response regression (dfrr) model as
 \deqn{Y_{i}(t)=I(\beta_0(t)+\beta_1(t)*x_{1i}+\ldots+\beta_{q-1}(t)*x_{(q-1)i}+\varepsilon_{i}(t)+\epsilon_{i}(t)\times\sigma^2>0),}
 where \eqn{I(.)} is the indicator function, \eqn{\varepsilon_{i}} is a Gaussian random function, and \eqn{\epsilon_{i}(t)} are iid standard normal for each \eqn{i} and \eqn{t} independent of \eqn{\varepsilon_{i}}.
 \eqn{\beta_k} and \eqn{x_k} for \eqn{k=0,1,\ldots,q-1} are the functional regression coefficients and scalar covariates, respectively.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)
#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
plot(dfrr_fit)
}
#Fitting dfrr model to the Madras Longitudinal Schizophrenia data
data(madras)
ids<-unique(madras$id)
N<-length(ids)

ydata<-data.frame(.obs=madras$id,.index=madras$month,.value=madras$y)

xdata<-data.frame(Age=rep(NA,N),Gender=rep(NA,N))
for(i in 1:N){
  dt<-madras[madras$id==ids[i],]
  xdata[i,]<-c(dt$age[1],dt$gender[1])
}
rownames(xdata)<-ids

#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
#J is the number of basis functions that will be used in estimating the functional parameters.
madras_dfrr<-dfrr(Y~Age+Gender+Age*Gender, data=xdata, ydata=ydata, J=11,T_E=1)

\donttest{
coefs<-coef(madras_dfrr)
plot(coefs)

fpcs<-fpca(madras_dfrr)
plot(fpcs)
plot(fpcs,plot.eigen.functions=FALSE,plot.contour=TRUE,plot.3dsurface = TRUE)

oldpar<-par(mfrow=c(2,2))

fitteds<-fitted(madras_dfrr) #Plot first four fitted functions
  plot(fitteds,id=c(1,2,3,4))
par(oldpar)

resids<-residuals(madras_dfrr)
plot(resids)


newdata<-data.frame(Age=c(1,1,0,0),Gender=c(1,0,1,0))
  preds<-predict(madras_dfrr,newdata=newdata)
  plot(preds)


newdata<-data.frame(Age=c(1,1,0,0),Gender=c(1,0,1,0))
newydata<-data.frame(.obs=rep(1,5),.index=c(0,1,3,4,5),.value=c(1,1,1,0,0))
preds<-predict(madras_dfrr,newdata=newdata,newydata = newydata)
plot(preds)
}

}
