% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{continue}
\alias{continue}
\title{Continue the training of a DGP emulator}
\usage{
continue(object, N = 500, ess_burn = 10, verb = TRUE, burnin = NULL, B = 50)
}
\arguments{
\item{object}{an instance of the \code{dgp} class.}

\item{N}{additional number of iterations for the DGP emulator training. Defaults to \code{500}.}

\item{ess_burn}{number of burnin steps for the ESS-within-Gibbs
at each I-step of the training. Defaults to \code{10}.}

\item{verb}{a bool indicating if the progress bar will be printed during the training:
\enumerate{
\item \code{FALSE}: the training progress bar will not be displayed.
\item \code{TRUE}: the training progress bar will be displayed.
}

Defaults to \code{TRUE}.}

\item{burnin}{the number of training iterations to be discarded for
point estimates calculation. Must be smaller than the overall training iterations
so-far implemented. If this is not specified, only the last 25\% of iterations
are used. This overrides the value of \code{burnin} set in \code{\link[=dgp]{dgp()}}. Defaults to \code{NULL}.}

\item{B}{the number of imputations to produce the predictions. Increase the value to account for
more imputation uncertainties. This overrides the value of \code{B} set in \code{\link[=dgp]{dgp()}}. Defaults to \code{50}.}
}
\value{
An updated \code{object}.
}
\description{
This function implements additional training iterations for a DGP emulator.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
One can also use this function to fit an untrained DGP emulator constructed by \code{\link[=dgp]{dgp()}} with \code{training = FALSE}.
}
\examples{
\dontrun{

# See dgp() for an example.
}
}
