% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted_quantile}
\alias{weighted_quantile}
\title{Weighted quantiles}
\usage{
weighted_quantile(x, w, probs = probs, na.rm)
}
\arguments{
\item{x}{A numeric vector or matrix. For matrix, the quantiles are computed 
for each column.}

\item{w}{A numeric vector of non-negative weights. Will be automatically 
normalised to sum to one.}

\item{probs}{A numeric vector of probabilities with values between 0 and 1.}

\item{na.rm}{If \code{TRUE}, \code{NA} and \code{NaN} values in \code{x} 
(and corresponding weights in \code{w}) are omitted from the computation. 
Default is \code{FALSE}. Additional missing values in \code{w} are not 
allowed.}
}
\value{
A weighted variance.
}
\description{
Computes a weighted quantiles of a vector or matrix. Based on the formula in 
Wikipedia (see the vignette) which is one of many ways to compute weighted 
quantiles.
}
\note{
Compared to some other R functions, here the weights are regarded as 
probability weights, not frequency weights.
}
