% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phone.R
\name{dialr-valid}
\alias{dialr-valid}
\alias{is_parsed}
\alias{is_valid}
\alias{is_possible}
\title{Phone number validity checks}
\usage{
is_parsed(x)

is_valid(x)

is_possible(x, detailed = FALSE, type = NULL)
}
\arguments{
\item{x}{A \link{phone} vector.}

\item{detailed}{If \code{FALSE}, \code{is_possible} returns a logical vector. If
\code{TRUE}, it returns a character vector with \code{"IS_POSSIBLE"} or the reason
for failure. See Details section for possible return values.}

\item{type}{If provided, checks if \code{x} is possible for the given \link[=dialr-region]{phone number type}.}
}
\description{
For each element of \code{x}:
\itemize{
\item \code{is_parsed(x)}: Was this successfully parsed?
\item \code{is_valid(x)}: Is this a valid phone number?
\item \code{is_possible(x)}: Is this a possible phone number? Return type depends on
\code{detailed}.
}
}
\details{
Possible return values for \code{is_possible(x, detailed = TRUE)}:
\itemize{
\item \code{"INVALID_COUNTRY_CODE"}: The number has an invalid country calling code.
\item \code{"INVALID_LENGTH"}: The number is longer than the shortest valid numbers
for this region, shorter than the longest valid numbers for this region,
and does not itself have a number length that matches valid numbers for
this region.
\item \code{"IS_POSSIBLE"}: The number length matches that of valid numbers for this
region.
\item \code{"IS_POSSIBLE_LOCAL_ONLY"}: The number length matches that of local numbers
for this region only (i.e. numbers that may be able to be dialled within an
area, but do not have all the information to be dialled from anywhere inside
or outside the country).
\item \code{"TOO_LONG"}: The number is longer than all valid numbers for this region.
\item \code{"TOO_SHORT"}: The number is shorter than all valid numbers for this
region.
}
}
\section{libphonenumber reference}{


\code{is_valid()}: \code{PhoneNumberUtil.isValidNumber()}

\code{is_possible()}: \code{PhoneNumberUtil.isPossibleNumber()}

\code{is_possible(detailed = TRUE)}: \code{PhoneNumberUtil.isPossibleNumberWithReason()}

\code{is_possible(type = type)}: \code{PhoneNumberUtil.isPossibleNumberForType()}

\code{is_possible(detailed = TRUE, type = type)}: \code{PhoneNumberUtil.sPossibleNumberForTypeWthReason()}
}

\examples{
  x <- phone(c(0, 0123, "0412 345 678", "61412987654", "03 9123 4567", "+12015550123"), "AU")

  is_parsed(x)
  is_valid(x)

  is_possible(x)
  is_possible(x, detailed = TRUE)

  is_possible(x, type = "MOBILE")
  is_possible(x, detailed = TRUE, type = "MOBILE")
}
\seealso{
Other phone functions: \code{\link{dialr-example}},
  \code{\link{dialr-match}}, \code{\link{dialr-phone}},
  \code{\link{dialr-region}}, \code{\link{dialr-type}},
  \code{\link{dialr}}
}
\concept{phone functions}
