/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.prefixmapper.PrefixTimeZonesMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumberToTimeZonesMapper {
    private static final String MAPPING_DATA_DIRECTORY = "/com/google/i18n/phonenumbers/timezones/data/";
    private static final String MAPPING_DATA_FILE_NAME = "map_data";
    private static final String UNKNOWN_TIMEZONE = "Etc/Unknown";
    static final List<String> UNKNOWN_TIME_ZONE_LIST = new ArrayList<String>(1);
    private static final Logger logger;
    private PrefixTimeZonesMap prefixTimeZonesMap = null;

    PhoneNumberToTimeZonesMapper(String prefixTimeZonesMapDataDirectory) {
        String string = String.valueOf(prefixTimeZonesMapDataDirectory);
        String string2 = String.valueOf(MAPPING_DATA_FILE_NAME);
        this.prefixTimeZonesMap = PhoneNumberToTimeZonesMapper.loadPrefixTimeZonesMapFromFile(string2.length() != 0 ? string.concat(string2) : new String(string));
    }

    private PhoneNumberToTimeZonesMapper(PrefixTimeZonesMap prefixTimeZonesMap) {
        this.prefixTimeZonesMap = prefixTimeZonesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrefixTimeZonesMap loadPrefixTimeZonesMapFromFile(String path) {
        InputStream source = PhoneNumberToTimeZonesMapper.class.getResourceAsStream(path);
        ObjectInputStream in = null;
        PrefixTimeZonesMap map = new PrefixTimeZonesMap();
        try {
            in = new ObjectInputStream(source);
            map.readExternal((ObjectInput)in);
        }
        catch (IOException e) {
            try {
                logger.log(Level.WARNING, e.toString());
            }
            catch (Throwable throwable) {
                PhoneNumberToTimeZonesMapper.close(in);
                throw throwable;
            }
            PhoneNumberToTimeZonesMapper.close(in);
        }
        PhoneNumberToTimeZonesMapper.close(in);
        return map;
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.toString());
            }
        }
    }

    public static synchronized PhoneNumberToTimeZonesMapper getInstance() {
        return LazyHolder.INSTANCE;
    }

    public List<String> getTimeZonesForGeographicalNumber(Phonenumber.PhoneNumber number) {
        return this.getTimeZonesForGeocodableNumber(number);
    }

    public List<String> getTimeZonesForNumber(Phonenumber.PhoneNumber number) {
        PhoneNumberUtil.PhoneNumberType numberType = PhoneNumberUtil.getInstance().getNumberType(number);
        if (numberType == PhoneNumberUtil.PhoneNumberType.UNKNOWN) {
            return UNKNOWN_TIME_ZONE_LIST;
        }
        if (!PhoneNumberUtil.getInstance().isNumberGeographical(numberType, number.getCountryCode())) {
            return this.getCountryLevelTimeZonesforNumber(number);
        }
        return this.getTimeZonesForGeographicalNumber(number);
    }

    public static String getUnknownTimeZone() {
        return UNKNOWN_TIMEZONE;
    }

    private List<String> getTimeZonesForGeocodableNumber(Phonenumber.PhoneNumber number) {
        List timezones = this.prefixTimeZonesMap.lookupTimeZonesForNumber(number);
        return Collections.unmodifiableList(timezones.isEmpty() ? UNKNOWN_TIME_ZONE_LIST : timezones);
    }

    private List<String> getCountryLevelTimeZonesforNumber(Phonenumber.PhoneNumber number) {
        List timezones = this.prefixTimeZonesMap.lookupCountryLevelTimeZonesForNumber(number);
        return Collections.unmodifiableList(timezones.isEmpty() ? UNKNOWN_TIME_ZONE_LIST : timezones);
    }

    static {
        UNKNOWN_TIME_ZONE_LIST.add(UNKNOWN_TIMEZONE);
        logger = Logger.getLogger(PhoneNumberToTimeZonesMapper.class.getName());
    }

    private static class LazyHolder {
        private static final PhoneNumberToTimeZonesMapper INSTANCE;

        private LazyHolder() {
        }

        static {
            PrefixTimeZonesMap map = PhoneNumberToTimeZonesMapper.loadPrefixTimeZonesMapFromFile("/com/google/i18n/phonenumbers/timezones/data/map_data");
            INSTANCE = new PhoneNumberToTimeZonesMapper(map);
        }
    }
}

